<?php
require_once __DIR__ . '/config.php';

$error = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = trim($_POST['password'] ?? '');

    $stmt = $pdo->prepare("SELECT * FROM admin_users WHERE username = ? AND password = ?");
    $stmt->execute([$username, $password]);
    $admin = $stmt->fetch();

    if ($admin) {
        $_SESSION['pending_2fa'] = $admin['id'];
        $error = "";
        header('Location: verify.php');
        exit;
    } else {
        $error = "Kullanıcı adı veya şifre hatalı.";
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Al Ajan Admin Giriş</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: radial-gradient(circle at top, #111827, #020617);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #e5e7eb;
        }
        .card {
            border-radius: 1.5rem;
            border: 1px solid rgba(148, 163, 184, 0.3);
            background: rgba(15, 23, 42, 0.9);
            box-shadow: 0 24px 80px rgba(15, 23, 42, 0.8);
        }
        .brand {
            font-weight: 700;
            letter-spacing: .12em;
            text-transform: uppercase;
            font-size: .8rem;
            color: #818cf8;
        }
        .btn-primary {
            border-radius: .9rem;
            font-weight: 600;
        }
        .form-control {
            border-radius: .8rem;
            background-color: #020617;
            border-color: #1f2937;
            color: #e5e7eb;
        }
        .form-control:focus {
            box-shadow: 0 0 0 1px #6366f1;
            border-color: #6366f1;
        }
    </style>
</head>
<body>
<div class="container px-3">
    <div class="row justify-content-center">
        <div class="col-md-5">
            <div class="card p-4 p-md-5">
                <div class="mb-4 text-center">
                    <div class="brand mb-2">AL AJAN</div>
                    <h2 class="h4 fw-bold mb-1">Yönetici Girişi</h2>
                    <p class="text-secondary mb-0">Panel erişimi için hesabınızla giriş yapın.</p>
                </div>

                <?php if ($error): ?>
                    <div class="alert alert-danger py-2"><?php echo htmlspecialchars($error); ?></div>
                <?php endif; ?>

                <form method="post" autocomplete="off">
                    <div class="mb-3">
                        <label class="form-label">Kullanıcı Adı</label>
                        <input type="text" name="username" class="form-control" placeholder="admin" required>
                    </div>
                    <div class="mb-4">
                        <label class="form-label">Şifre</label>
                        <input type="password" name="password" class="form-control" placeholder="Admin123!" required>
                    </div>
                    <button type="submit" class="btn btn-primary w-100 py-2">
                        Devam Et
                    </button>
                </form>
                <p class="mt-3 mb-0 text-center text-secondary" style="font-size: .8rem;">
                    Varsayılan giriş: <strong>admin / Admin123!</strong>
                </p>
            </div>
        </div>
    </div>
</div>
</body>
</html>
