<?php
require_once __DIR__ . '/config.php';
requireLogin();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Al Ajan Admin Paneli</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #020617; color: #e5e7eb; }
        .navbar { background: #020617; border-bottom: 1px solid #1f2937; }
        .card {
            border-radius: 1.5rem;
            border: 1px solid rgba(148, 163, 184, 0.25);
            background: radial-gradient(circle at top left, #020617, #020617);
        }
        .badge-soft {
            background-color: rgba(129, 140, 248, 0.15);
            color: #a5b4fc;
        }
    </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark mb-4">
  <div class="container-fluid px-4">
    <a class="navbar-brand fw-bold" href="dashboard.php">AL AJAN • ADMIN</a>
    <div class="d-flex">
      <a href="agents.php" class="btn btn-sm btn-outline-light me-2">Ajanlar</a>
      <a href="logout.php" class="btn btn-sm btn-danger">Çıkış</a>
    </div>
  </div>
</nav>

<div class="container px-4">
    <div class="row g-4">
        <div class="col-md-4">
            <div class="card p-4 h-100">
                <h5 class="mb-2">Hoş geldin 👋</h5>
                <p class="text-secondary mb-0">Al Ajan Marketplace yöneticisi olarak buradan tüm ajanları, paketleri ve kullanım limitlerini yöneteceksin.</p>
            </div>
        </div>
        <div class="col-md-8">
            <div class="card p-4 h-100">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h6 class="mb-0">Hızlı Kısayollar</h6>
                </div>
                <div class="row g-3">
                    <div class="col-md-4">
                        <a href="agents.php" class="text-decoration-none">
                            <div class="border rounded-4 p-3 h-100">
                                <div class="fw-semibold mb-1 text-light">Ajan Listesi</div>
                                <div class="text-secondary" style="font-size:.85rem;">Tüm hazır ajanları görüntüle & düzenle.</div>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-4">
                        <div class="border rounded-4 p-3 h-100">
                            <div class="fw-semibold mb-1 text-light">Paketler</div>
                            <div class="text-secondary" style="font-size:.85rem;">(Sonra) Basic / Silver / Gold paket yönetimi.</div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="border rounded-4 p-3 h-100">
                            <div class="fw-semibold mb-1 text-light">Loglar</div>
                            <div class="text-secondary" style="font-size:.85rem;">(Sonra) Ajan kullanım loglarını izle.</div>
                        </div>
                    </div>
                </div>
                <span class="badge badge-soft mt-3">v0.1 • Sadece ajan listesi aktif</span>
            </div>
        </div>
    </div>
</div>
</body>
</html>
