<?php
require_once __DIR__ . '/config.php';
requireLogin();

$stmt = $pdo->query("SELECT * FROM agents ORDER BY id DESC");
$agents = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Ajanlar - Al Ajan Admin</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #020617; color: #e5e7eb; }
        .navbar { background: #020617; border-bottom: 1px solid #1f2937; }
        .card {
            border-radius: 1.5rem;
            border: 1px solid rgba(148, 163, 184, 0.25);
            background: radial-gradient(circle at top left, #020617, #020617);
        }
        table thead { background-color: #020617; }
        table thead th { color: #9ca3af; font-size: .8rem; text-transform: uppercase; letter-spacing: .06em; }
        table tbody td { vertical-align: middle; font-size: .9rem; }
        .badge-active { background-color: rgba(22, 163, 74, .18); color: #4ade80; }
        .badge-passive { background-color: rgba(220, 38, 38, .18); color: #f87171; }
    </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark mb-4">
  <div class="container-fluid px-4">
    <a class="navbar-brand fw-bold" href="dashboard.php">AL AJAN • ADMIN</a>
    <div class="d-flex">
      <a href="agents.php" class="btn btn-sm btn-outline-light me-2">Ajanlar</a>
      <a href="logout.php" class="btn btn-sm btn-danger">Çıkış</a>
    </div>
  </div>
</nav>

<div class="container px-4">
    <div class="card p-4">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <div>
                <h5 class="mb-1">Ajan Listesi</h5>
                <p class="text-secondary mb-0" style="font-size:.9rem;">Veritabanındaki tüm ajan kayıtları listeleniyor.</p>
            </div>
            <!-- Sonra ekleme/düzenleme butonları gelecek -->
        </div>

        <div class="table-responsive">
            <table class="table table-dark table-striped align-middle mb-0">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Ad</th>
                        <th>Kategori</th>
                        <th>Fiyat (TL)</th>
                        <th>Model</th>
                        <th>Aktif mi?</th>
                        <th>Limit (Aylık)</th>
                    </tr>
                </thead>
                <tbody>
                <?php if (empty($agents)): ?>
                    <tr>
                        <td colspan="7" class="text-center text-secondary py-4">Henüz ajan bulunmuyor.</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($agents as $a): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($a['id']); ?></td>
                            <td><?php echo htmlspecialchars($a['name']); ?></td>
                            <td><?php echo htmlspecialchars($a['category'] ?? '-'); ?></td>
                            <td><?php echo htmlspecialchars($a['price']); ?></td>
                            <td><?php echo htmlspecialchars($a['model'] ?? '-'); ?></td>
                            <td>
                                <?php if (!empty($a['is_active'])): ?>
                                    <span class="badge badge-active">Aktif</span>
                                <?php else: ?>
                                    <span class="badge badge-passive">Pasif</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo htmlspecialchars($a['monthly_limit']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
        <p class="text-secondary mt-3 mb-0" style="font-size:.8rem;">Daha sonra “düzenle / sil / yeni ekle” butonlarını ekleyeceğiz.</p>
    </div>
</div>
</body>
</html>
