<?php
header('Content-Type: application/json');
require_once __DIR__.'/config.php';

$input = json_decode(file_get_contents("php://input"), true);
$agent_id = $input["agent_id"] ?? 0;
$message = $input["message"] ?? "";

$stmt = $pdo->prepare("SELECT * FROM agents WHERE id=?");
$stmt->execute([$agent_id]);
$agent = $stmt->fetch();

if(!$agent){ echo json_encode(["error"=>"Agent not found"]); exit; }

$openai_key = $agent["api_key"] ?: "PUT_YOUR_KEY";
$model = $agent["model"] ?: "gpt-4o-mini";

$payload = [
 "model"=>$model,
 "messages"=>[
   ["role"=>"user","content"=>$message]
 ]
];

$ch = curl_init("https://api.openai.com/v1/chat/completions");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
 "Content-Type: application/json",
 "Authorization: Bearer ".$openai_key
]);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

$response = curl_exec($ch);
curl_close($ch);

echo $response;
